; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

; This vscale udiv with a power-of-2 splat on the rhs should not crash opt

define <vscale x 2 x i32> @udiv_pow2_vscale(<vscale x 2 x i32> %lhs) {
; CHECK-LABEL: define <vscale x 2 x i32> @udiv_pow2_vscale(
; CHECK-SAME: <vscale x 2 x i32> [[LHS:%.*]]) {
; CHECK-NEXT:    [[RES1:%.*]] = lshr <vscale x 2 x i32> [[LHS]], splat (i32 1)
; CHECK-NEXT:    ret <vscale x 2 x i32> [[RES1]]
;
  %res = udiv <vscale x 2 x i32> %lhs, splat (i32 2)
  ret <vscale x 2 x i32> %res
}

; This fixed width udiv with a power-of-2 splat on the rhs should also not
; crash, and instcombine should eliminate the udiv

define <2 x i32> @udiv_pow2_fixed(<2 x i32> %lhs) {
; CHECK-LABEL: define <2 x i32> @udiv_pow2_fixed(
; CHECK-SAME: <2 x i32> [[LHS:%.*]]) {
; CHECK-NEXT:    [[RES1:%.*]] = lshr <2 x i32> [[LHS]], splat (i32 1)
; CHECK-NEXT:    ret <2 x i32> [[RES1]]
;
  %res = udiv <2 x i32> %lhs, splat (i32 2)
  ret <2 x i32> %res
}
